<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:ser="http://sales.bpelbuch.de/services">

	<xsl:param name="oid" />
	<xsl:output method="xml" />
	<xsl:strip-space elements="*"/>
	
	<xsl:template match="/">
		<xsl:element name="Items">
			<xsl:attribute name="OrderId">
				<xsl:copy-of select="$oid" />
			</xsl:attribute>
			<xsl:apply-templates />
		</xsl:element>
	</xsl:template>
	
	<xsl:template match="/ser:order/ser:OrderItem">
		<xsl:element name="Item">
			<xsl:attribute name="Amount">
				<xsl:value-of select="./@Amount" />
			</xsl:attribute>
			<xsl:attribute name="ProductId">
				<xsl:value-of select="./@ProductId" />
			</xsl:attribute>
		</xsl:element>
	</xsl:template>
	
</xsl:stylesheet>